<?php
session_start();
require 'conexao.php';

$ip = $_SERVER['REMOTE_ADDR'];
$email = $_POST['email'] ?? null;
$senha = $_POST['senha'] ?? null;

if ($_SERVER["REQUEST_METHOD"] !== "POST" || !$email || !$senha) {
    header('Location: login.php');
    exit;
}

function verificarBloqueios($pdo, $ip, $email) {
    $agora = date('Y-m-d H:i:s');

    // IP bloqueado
    $stmt = $pdo->prepare("SELECT * FROM bloqueios WHERE tipo = 'ip' AND ip = ?");
    $stmt->execute([$ip]);
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['permanente']) {
            return "IP bloqueado permanentemente. Entre em contato conosco para desbloquear sua conta.";
        } elseif ($row['bloqueado_ate'] > $agora) {
            return "Seu IP foi temporariamente bloqueado. Tente novamente mais tarde.";
        }
    }

    // Email bloqueado
    $stmt = $pdo->prepare("SELECT * FROM bloqueios WHERE tipo = 'email' AND email = ?");
    $stmt->execute([$email]);
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['permanente']) {
            return "Email bloqueado permanentemente. Entre em contato conosco para desbloquear sua conta.";
        } elseif ($row['bloqueado_ate'] > $agora) {
            return "Este email foi temporariamente bloqueado. Tente novamente mais tarde.";
        }
    }

    return false;
}

function registrarTentativa($pdo, $ip, $email) {
    $stmt = $pdo->prepare("INSERT INTO tentativas_login (ip, email_tentado) VALUES (?, ?)");
    $stmt->execute([$ip, $email]);
}

function aplicarRegrasBloqueio($pdo, $ip, $email) {
    $pdo->beginTransaction();

    // IP em 30 min
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tentativas_login WHERE ip = ? AND horario > (NOW() - INTERVAL 30 MINUTE)");
    $stmt->execute([$ip]);
    $ip_30min = $stmt->fetchColumn();

    // IP em 7 horas
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tentativas_login WHERE ip = ? AND horario > (NOW() - INTERVAL 7 HOUR)");
    $stmt->execute([$ip]);
    $ip_7h = $stmt->fetchColumn();

    // Email em 30 min
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tentativas_login WHERE email_tentado = ? AND horario > (NOW() - INTERVAL 30 MINUTE)");
    $stmt->execute([$email]);
    $email_30min = $stmt->fetchColumn();

    // Email em 6 horas
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tentativas_login WHERE email_tentado = ? AND horario > (NOW() - INTERVAL 6 HOUR)");
    $stmt->execute([$email]);
    $email_6h = $stmt->fetchColumn();

    // Aplicar bloqueios
    if ($ip_30min >= 5) {
        $stmt = $pdo->prepare("INSERT INTO bloqueios (ip, tipo, bloqueado_ate) VALUES (?, 'ip', DATE_ADD(NOW(), INTERVAL 30 MINUTE))");
        $stmt->execute([$ip]);
    }

    if ($ip_7h >= 15) {
        $stmt = $pdo->prepare("INSERT INTO bloqueios (ip, tipo, permanente) VALUES (?, 'ip', 1)");
        $stmt->execute([$ip]);
    }

    if ($email_30min >= 5) {
        $stmt = $pdo->prepare("INSERT INTO bloqueios (email, tipo, bloqueado_ate) VALUES (?, 'email', DATE_ADD(NOW(), INTERVAL 30 MINUTE))");
        $stmt->execute([$email]);
    }

    if ($email_6h >= 15) {
        $stmt = $pdo->prepare("INSERT INTO bloqueios (email, tipo, permanente) VALUES (?, 'email', 1)");
        $stmt->execute([$email]);
    }

    $pdo->commit();
}

// Verificar bloqueio
$bloqueioMsg = verificarBloqueios($pdo, $ip, $email);
if ($bloqueioMsg) {
    header("Location: login.php?erro=" . urlencode($bloqueioMsg));
    exit;
}

// Registrar tentativa
registrarTentativa($pdo, $ip, $email);

// Aplicar regras de bloqueio
aplicarRegrasBloqueio($pdo, $ip, $email);

// Validar login
try {
    $stmt = $pdo->prepare("SELECT * FROM usersblock WHERE email = ?");
    $stmt->execute([$email]);

    if ($stmt->rowCount() === 1) {
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        if (password_verify($senha, $usuario['password'])) {
            $_SESSION['user_id'] = $usuario['id'];
            $_SESSION['user_name'] = $usuario['user'];
            $_SESSION['user_wallet'] = $usuario['wallet'];
            $_SESSION['user_pin'] = $usuario['pin'];
            $_SESSION['user_altemail'] = $usuario['altemail'];
            $_SESSION['email'] = $email;

            header('Location: altenticar2.php');
            exit;
        }
    }

    // Falha no login
    header("Location: login.php?erro=" . urlencode("Email ou senha incorretos."));
    exit;

} catch (PDOException $e) {
    header("Location: login.php?erro=" . urlencode("Erro interno ao autenticar."));
    exit;
}
