<?php
// api/setup_financeiro.php
header('Content-Type: text/html; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>🛠️ Diagnóstico e Reparo do Sistema Financeiro</h1>";

// 1. VERIFICAR ARQUIVOS
echo "<h3>1. Verificando Arquivos...</h3>";

if (file_exists('../conexao.php')) {
    require '../conexao.php';
    echo "<p style='color:green'>✅ conexao.php encontrado.</p>";
} elseif (file_exists('../../conexao.php')) {
    require '../../conexao.php';
    echo "<p style='color:green'>✅ conexao.php encontrado (dois níveis acima).</p>";
} else {
    die("<p style='color:red'>❌ ERRO FATAL: conexao.php não encontrado!</p>");
}

if (file_exists('Financeiro.php')) {
    require 'Financeiro.php';
    echo "<p style='color:green'>✅ Financeiro.php encontrado.</p>";
} else {
    die("<p style='color:red'>❌ ERRO FATAL: Financeiro.php não encontrado na pasta api!</p>");
}

// 2. VERIFICAR E CORRIGIR BANCO DE DADOS
echo "<h3>2. Verificando Banco de Dados...</h3>";

try {
    // Verifica se a tabela transacoes existe
    $pdo->query("SELECT 1 FROM transacoes LIMIT 1");
    echo "<p style='color:green'>✅ Tabela 'transacoes' existe.</p>";
    
    // Tenta atualizar o ENUM para aceitar APOSTA_JOGO
    echo "<p>Tentando atualizar tipos de transação permitidos...</p>";
    $sqlFixEnum = "ALTER TABLE transacoes MODIFY COLUMN tipo ENUM('DEPOSITO', 'SAQUE', 'DEPOSITO_MANUAL', 'COMPRA_TERRITORIO', 'GANHO_BATALHA', 'PERDA_BATALHA', 'APOSTA_JOGO') NOT NULL";
    $pdo->exec($sqlFixEnum);
    echo "<p style='color:green'>✅ Coluna 'tipo' atualizada com sucesso (Aceita APOSTA_JOGO).</p>";

} catch (PDOException $e) {
    if ($e->getCode() == '42S02') { // Tabela não existe
        echo "<p style='color:orange'>⚠️ Tabela 'transacoes' não existe. Criando agora...</p>";
        $sqlCreate = "CREATE TABLE transacoes (
            id BIGINT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            tipo ENUM('DEPOSITO', 'SAQUE', 'DEPOSITO_MANUAL', 'COMPRA_TERRITORIO', 'GANHO_BATALHA', 'PERDA_BATALHA', 'APOSTA_JOGO') NOT NULL,
            valor DECIMAL(15, 2) NOT NULL,
            saldo_anterior DECIMAL(15, 2) NOT NULL,
            saldo_posterior DECIMAL(15, 2) NOT NULL,
            referencia_id VARCHAR(100),
            descricao TEXT,
            data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
            CONSTRAINT fk_user_transacao FOREIGN KEY (user_id) REFERENCES usersblock(id)
        ) ENGINE=InnoDB;";
        try {
            $pdo->exec($sqlCreate);
            echo "<p style='color:green'>✅ Tabela criada com sucesso.</p>";
        } catch (Exception $ex) {
            die("<p style='color:red'>❌ Erro ao criar tabela: " . $ex->getMessage() . "</p>");
        }
    } else {
        echo "<p style='color:red'>❌ Erro de Banco: " . $e->getMessage() . "</p>";
    }
}

// 3. TESTE FINAL
echo "<h3>3. Conclusão</h3>";
echo "<h2 style='color:blue'>Tudo parece correto! Tente criar o jogo novamente.</h2>";
?>