<?php
// api/sistema_finalizar_jogo.php
// ATENÇÃO: Verifique se NÃO HÁ NADA (espaços, linhas vazias) antes desta tag <?php
ini_set('display_errors', 0);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

if (file_exists('../conexao.php')) require '../conexao.php';
else require '../../conexao.php';

require 'Financeiro.php';

// Constantes
define('TERRITORIO_VALOR', 2.00); // Valor de compra/venda de um território

try {
    $gameId = $_POST['game_id'] ?? null;
    $vencedorUid = $_POST['winner_uid'] ?? null;

    if (!$gameId || !$vencedorUid) {
        throw new Exception("Dados de finalização incompletos.");
    }

    $pdo->beginTransaction();
    $banco = new Financeiro($pdo);

    // 1. OBTÉM DADOS DO JOGO NO MYSQL (usando FOR UPDATE para travar o registro)
    $sqlGame = "SELECT * FROM games WHERE game = ? AND status = 'iniciado' FOR UPDATE";
    $stmtGame = $pdo->prepare($sqlGame);
    $stmtGame->execute([$gameId]);
    $game = $stmtGame->fetch(PDO::FETCH_ASSOC);

    if (!$game) {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'msg' => 'Jogo já finalizado ou inválido.']);
        exit;
    }
    
    // Define P1 (Atacante) e P2 (Defensor)
    $p1Id = $game['p1']; // ID do Atacante (MySQL ID)
    $p2Id = $game['p2']; // ID do Defensor (MySQL ID)
    
    // O vencedor_uid é o ID do Firebase/Google, precisamos do ID do MySQL
    $vencedorId = ($game['p1'] == $vencedorUid) ? $p1Id : $p2Id; 
    $perdedorId = ($vencedorId == $p1Id) ? $p2Id : $p1Id;
    
    $alvoTerritorioId = $game['alvo_territorio_id'];
    $tipoDisputa = $game['tipo_disputa']; // 'grupo' ou 'territorio'

    $p1Win = ($vencedorId == $p1Id);
    $alvoTerritorioData = null;

    // 2. OBTÉM DADOS DO TERRITÓRIO ALVO
    if ($alvoTerritorioId) {
        $sqlAlvo = "SELECT * FROM territorios WHERE id = ? FOR UPDATE";
        $stmtAlvo = $pdo->prepare($sqlAlvo);
        $stmtAlvo->execute([$alvoTerritorioId]);
        $alvoTerritorioData = $stmtAlvo->fetch(PDO::FETCH_ASSOC);
        
        if (!$alvoTerritorioData) { $pdo->rollBack(); throw new Exception("Território alvo não encontrado."); }
    }
    
    // Obtém nome do vencedor e perdedor para logging e feedback
    $vencedorNome = $pdo->query("SELECT nome FROM usersblock WHERE id = $vencedorId")->fetchColumn();
    $perdedorNome = $pdo->query("SELECT nome FROM usersblock WHERE id = $perdedorId")->fetchColumn();
    

    // =========================================================================
    // 3. PROCESSAMENTO CENTRAL DA LÓGICA DE APOSTA/RECOMPENSA
    // =========================================================================

    if ($tipoDisputa == 'grupo') {
        // --- ATAQUE COM GRUPO DE ATAQUE ---
        
        $grupoId = $pdo->query("SELECT id FROM grupos_ataque WHERE dono_id=$p1Id AND status='em_missao' LIMIT 1 FOR UPDATE")->fetchColumn();
        
        if ($p1Win) { // Vencedor é o Atacante (P1)
            // 3.1 VENCEDOR (P1) CONQUISTA O TERRITÓRIO
            $pdo->prepare("UPDATE territorios SET dono_id=?, nome_dono=?, nome_personalizado=?, em_guerra=0 WHERE id=?")
                ->execute([$vencedorId, $vencedorNome, $alvoTerritorioData['nome_personalizado'], $alvoTerritorioId]);
            
            // 3.2 GRUPO DO VENCEDOR (P1) É LIBERADO
            if ($grupoId) $pdo->query("UPDATE grupos_ataque SET status='pronto' WHERE id=" . $grupoId);
            
            $feedbackVencedor = "🏆 Vitória! Você conquistou o território {$alvoTerritorioData['nome_personalizado']}. Seu grupo de ataque retornou à base.";
            $feedbackPerdedor = "💀 Derrota! Você perdeu o território {$alvoTerritorioData['nome_personalizado']}.";

        } else { // Vencedor é o Defensor (P2)
            // 3.1 TERRITÓRIO DO DEFENSOR (P2) É LIBERADO (Permanece com ele)
            $pdo->query("UPDATE territorios SET em_guerra=0 WHERE id=" . $alvoTerritorioId);
            
            // 3.2 PERDEDOR (P1) PERDE O GRUPO
            if ($grupoId) $pdo->query("DELETE FROM grupos_ataque WHERE id=" . $grupoId);
            
            // 3.3 VENCEDOR (P2) GANHA RECOMPENSA FINANCEIRA
            $banco->processarTransacao($vencedorId, TERRITORIO_VALOR, 'RECOMPENSA_DEFESA_GRUPO', "Grupo do P1 destruído (Game {$gameId})");

            $feedbackVencedor = "🛡️ Defesa concluída! Você manteve seu território e recebeu R$ ".number_format(TERRITORIO_VALOR, 2, ',', '.')." de recompensa.";
            $feedbackPerdedor = "💀 Derrota! Seu grupo de ataque foi destruído. Você perdeu o valor investido.";
        }

    } elseif ($tipoDisputa == 'territorio') {
        // --- ATAQUE COM TERRITÓRIO (Garantia) ---
        
        $origemTerritorioId = $game['origem_territorio_id'];
        $origemTerritorioData = $pdo->query("SELECT nome_personalizado FROM territorios WHERE id = {$origemTerritorioId} FOR UPDATE")->fetch(PDO::FETCH_ASSOC);

        if (!$origemTerritorioData) { $pdo->rollBack(); throw new Exception("Território de origem (aposta) não encontrado ou já foi movido."); }

        $recompensaValor = TERRITORIO_VALOR; 

        if ($p1Win) { // Vencedor é o Atacante (P1)
            // 3.1 VENCEDOR (P1) CONQUISTA O TERRITÓRIO ALVO
            $pdo->prepare("UPDATE territorios SET dono_id=?, nome_dono=?, nome_personalizado=?, em_guerra=0 WHERE id=?")
                ->execute([$vencedorId, $vencedorNome, $alvoTerritorioData['nome_personalizado'], $alvoTerritorioId]);
            
            // 3.2 TERRITÓRIO DE ORIGEM DO VENCEDOR (P1) É LIBERADO DA GUERRA
            $pdo->query("UPDATE territorios SET em_guerra=0 WHERE id=" . $origemTerritorioId);
            
            // 3.3 DEFENSOR (P2) PERDE O TERRITÓRIO ALVO, MAS RECEBE O VALOR DA GARANTIA
            $banco->processarTransacao($perdedorId, $recompensaValor, 'GARANTIA_TOMADA_POR_P2', "Perda do T:{$alvoTerritorioId}, ganho da garantia do atacante.");
            
            $feedbackVencedor = "🏆 Vitória! Você conquistou o território {$alvoTerritorioData['nome_personalizado']}. Seu território de origem ({$origemTerritorioData['nome_personalizado']}) está seguro.";
            $feedbackPerdedor = "💀 Derrota! Você perdeu o território {$alvoTerritorioData['nome_personalizado']}, mas recebeu a garantia de R$ ".number_format($recompensaValor, 2, ',', '.')." do atacante.";

        } else { // Vencedor é o Defensor (P2)
            // 3.1 TERRITÓRIO ALVO DO DEFENSOR (P2) É LIBERADO (Permanece com ele)
            $pdo->query("UPDATE territorios SET em_guerra=0 WHERE id=" . $alvoTerritorioId);
            
            // 3.2 TERRITÓRIO DE ORIGEM DO PERDEDOR (P1) É ABANDONADO/ESVAZIADO (Perda da garantia)
            // O território volta a ser livre para compra, e o valor é transferido.
            $pdo->query("UPDATE territorios SET dono_id=NULL, nome_dono=NULL, nome_personalizado=NULL, em_guerra=0, valor_atual=2.00 WHERE id=" . $origemTerritorioId);
            
            // 3.3 VENCEDOR (P2) GANHA RECOMPENSA FINANCEIRA
            $banco->processarTransacao($vencedorId, $recompensaValor, 'GARANTIA_TOMADA_POR_P2', "Defesa do T:{$alvoTerritorioId}, garantia do T:{$origemTerritorioId} tomada.");

            $feedbackVencedor = "🛡️ Defesa concluída! Você manteve seu território e tomou a garantia (R$ ".number_format($recompensaValor, 2, ',', '.').") do atacante. O território de origem dele foi abandonado.";
            $feedbackPerdedor = "💀 Derrota! Seu ataque falhou. Seu território de origem/garantia ({$origemTerritorioData['nome_personalizado']}) foi abandonado e o valor de garantia foi transferido ao defensor.";
        }
    }
    
    // =========================================================================
    // 4. FINALIZA O REGISTRO DO JOGO NO MYSQL
    // =========================================================================

    // Atualiza o status do jogo na tabela 'games'
    $pdo->prepare("UPDATE games SET status = 'finalizado', winner = ? WHERE game = ?")
        ->execute([$vencedorId, $gameId]);
    
    // 5. REGISTRO DE LOG COMPLETO (Para Auditoria/Histórico)
    $stmtLog = $pdo->prepare("INSERT INTO logs_guerra (game_id, vencedor_id, perdedor_id, territorio_alvo_id, territorio_origem_id, tipo_disputa, status) VALUES (?, ?, ?, ?, ?, ?, 'FINALIZADO')");
    $stmtLog->execute([
        $gameId, 
        $vencedorId, 
        $perdedorId, 
        $alvoTerritorioId, 
        ($tipoDisputa == 'territorio' ? $game['origem_territorio_id'] : NULL),
        $tipoDisputa
    ]);


    // 6. COMMIT
    $pdo->commit();

    // 7. RETORNO DE FEEDBACK (usa o UID do Firebase/Google para identificação)
    $responseP1 = ($p1Win) ? $feedbackVencedor : $feedbackPerdedor;
    $responseP2 = ($p1Win) ? $feedbackPerdedor : $feedbackVencedor;

    echo json_encode([
        'success' => true,
        'msg_p1' => $responseP1,
        'msg_p2' => $responseP2,
        'winner_id_db' => $vencedorId
    ]);

} catch (Exception $e) {
    // 8. ROLLBACK EM CASO DE FALHA
    if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    
    // Retorna o erro encapsulado para o JavaScript
    echo json_encode(['success' => false, 'msg' => "Erro no servidor: " . $e->getMessage()]);
}
?>