<?php
// api/reparar_banco.php
// Este script verifica o banco real que o site está usando e corrige a tabela.

header('Content-Type: text/html; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>🔧 Diagnóstico do Banco de Dados</h1>";

// 1. Tenta carregar a conexão
if (file_exists('../conexao.php')) {
    require '../conexao.php';
    echo "<p style='color:green'>✅ Arquivo conexao.php encontrado.</p>";
} else {
    die("<p style='color:red'>❌ ERRO: conexao.php não encontrado.</p>");
}

try {
    // 2. Verifica qual banco está conectado
    $stmt = $pdo->query("SELECT DATABASE()");
    $dbName = $stmt->fetchColumn();
    echo "<p><strong>Banco Conectado:</strong> <span style='background:yellow; padding:2px'>$dbName</span></p>";

    // 3. Verifica se a tabela usersblock existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'usersblock'");
    if ($stmt->rowCount() == 0) {
        die("<p style='color:red'>❌ A tabela 'usersblock' NÃO existe neste banco ($dbName).</p>");
    } else {
        echo "<p style='color:green'>✅ Tabela 'usersblock' encontrada.</p>";
    }

    // 4. Lista as colunas que o PHP está vendo AGORA
    echo "<h3>Colunas Atuais na tabela 'usersblock':</h3><ul>";
    $stmt = $pdo->query("DESCRIBE usersblock");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $temSaldo = false;
    foreach ($columns as $col) {
        echo "<li>" . $col['Field'] . " (" . $col['Type'] . ")</li>";
        if ($col['Field'] === 'saldo') {
            $temSaldo = true;
        }
    }
    echo "</ul>";

    // 5. Tenta corrigir se faltar
    if ($temSaldo) {
        echo "<h2 style='color:green'>✅ TUDO CERTO! A coluna 'saldo' já existe.</h2>";
        echo "<p>Se o erro persistir, verifique se seu código PHP está usando a variável correta no INSERT.</p>";
    } else {
        echo "<h2 style='color:orange'>⚠️ Coluna 'saldo' NÃO encontrada! Tentando criar...</h2>";
        
        try {
            $sql = "ALTER TABLE usersblock ADD COLUMN saldo DECIMAL(15, 2) DEFAULT 0.00 AFTER email";
            $pdo->exec($sql);
            echo "<h2 style='color:green'>✅ SUCESSO! Coluna 'saldo' criada via PHP.</h2>";
            echo "<p>Tente usar o sistema de depósito novamente.</p>";
        } catch (Exception $ex) {
            echo "<h2 style='color:red'>❌ FALHA AO CRIAR: " . $ex->getMessage() . "</h2>";
        }
    }

} catch (PDOException $e) {
    echo "<h2 style='color:red'>❌ Erro de Conexão: " . $e->getMessage() . "</h2>";
}
?>