<?php
// api/diagnostico_banco.php
// Este script verifica onde o conexao.php está conectando e conserta a tabela.

header('Content-Type: text/html; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>🕵️ Detetive de Banco de Dados</h1>";

// 1. Tenta carregar a conexão
if (file_exists('../conexao.php')) {
    require '../conexao.php';
    echo "<p>✅ Arquivo <code>../conexao.php</code> carregado.</p>";
} elseif (file_exists('../../conexao.php')) {
    require '../../conexao.php';
    echo "<p>✅ Arquivo <code>../../conexao.php</code> carregado.</p>";
} else {
    die("<h2 style='color:red'>❌ ERRO FATAL: Não achei conexao.php em lugar nenhum!</h2>");
}

try {
    // 2. Descobre qual banco está conectado DE VERDADE
    $stmt = $pdo->query("SELECT DATABASE()");
    $nomeBancoReal = $stmt->fetchColumn();
    
    echo "<h2>Você está conectado no banco: <span style='background: yellow; padding: 5px'>$nomeBancoReal</span></h2>";

    // 3. Verifica se a tabela usersblock existe NESTE banco
    $stmt = $pdo->query("SHOW TABLES LIKE 'usersblock'");
    if ($stmt->rowCount() == 0) {
        echo "<h3 style='color:red'>❌ A tabela 'usersblock' NÃO EXISTE neste banco ($nomeBancoReal)!</h3>";
        echo "<p>Verifique se o nome da tabela está correto no seu código.</p>";
        exit;
    } else {
        echo "<p>✅ Tabela <code>usersblock</code> encontrada.</p>";
    }

    // 4. Lista as colunas da tabela
    echo "<h3>Colunas da tabela usersblock:</h3><ul>";
    $stmt = $pdo->query("DESCRIBE usersblock");
    $colunas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $temSaldo = false;
    foreach ($colunas as $col) {
        echo "<li>" . $col['Field'] . " (" . $col['Type'] . ")</li>";
        if ($col['Field'] === 'saldo') {
            $temSaldo = true;
        }
    }
    echo "</ul>";

    // 5. O Veredito e a Correção
    if ($temSaldo) {
        echo "<h2 style='color:green'>✅ TUDO CERTO! A coluna 'saldo' já existe.</h2>";
        echo "<p>Se o erro continuar, o problema pode estar no 'INSERT' tentando inserir campos que não têm valor padrão.</p>";
    } else {
        echo "<h2 style='color:red'>❌ A COLUNA 'saldo' NÃO EXISTE!</h2>";
        echo "<p>Tentando criar agora...</p>";
        
        try {
            $sql = "ALTER TABLE usersblock ADD COLUMN saldo DECIMAL(15, 2) DEFAULT 0.00 AFTER email";
            $pdo->exec($sql);
            echo "<h2 style='color:green'>✅ SUCESSO! Coluna 'saldo' criada. Tente depositar novamente.</h2>";
        } catch (Exception $ex) {
            echo "<h2 style='color:red'>❌ FALHA AO CRIAR: " . $ex->getMessage() . "</h2>";
        }
    }

} catch (PDOException $e) {
    echo "<h2 style='color:red'>❌ Erro de Conexão PDO: " . $e->getMessage() . "</h2>";
}
?>