<?php
// api/adicionar_saldo.php

// 1. Configurações de Erro e Cabeçalho
ini_set('display_errors', 0); 
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

// Função para resposta padrão
function sendResponse($success, $msg, $data = []) {
    echo json_encode(array_merge(['success' => $success, 'msg' => $msg], $data));
    exit;
}

try {
    // 2. Verificação de Arquivos (Caminhos)
    if (file_exists('../conexao.php')) {
        require '../conexao.php';
    } elseif (file_exists('../../conexao.php')) {
        require '../../conexao.php';
    } else {
        throw new Exception("Arquivo 'conexao.php' não encontrado.");
    }
    
    if (file_exists('Financeiro.php')) {
        require 'Financeiro.php';
    } else {
        throw new Exception("Arquivo 'Financeiro.php' não encontrado.");
    }

    // 3. Validação do Request
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception("Método inválido.");
    }

    $emailAlvo = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    $valor = filter_input(INPUT_POST, 'valor', FILTER_VALIDATE_FLOAT);
    
    if (!$emailAlvo) throw new Exception("E-mail inválido.");
    if (!$valor || $valor <= 0) throw new Exception("Valor deve ser positivo.");

    // 4. Busca ou Cria Usuário (CORRIGIDO: Sem created_at)
    $stmt = $pdo->prepare("SELECT id FROM usersblock WHERE email = ?");
    $stmt->execute([$emailAlvo]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $userId = null;

    if (!$user) {
        // --- AQUI ESTAVA O ERRO, AGORA CORRIGIDO ---
        // Removemos o campo 'created_at' do INSERT
        try {
            $stmtCreate = $pdo->prepare("INSERT INTO usersblock (email, saldo) VALUES (?, 0.00)");
            $stmtCreate->execute([$emailAlvo]);
            $userId = $pdo->lastInsertId();
        } catch (PDOException $e) {
            throw new Exception("Erro fatal ao criar usuário no MySQL: " . $e->getMessage());
        }
    } else {
        $userId = $user['id'];
    }

    // 5. Executa a Transação Financeira
    $banco = new Financeiro($pdo);
    
    $resultado = $banco->processarTransacao(
        $userId, 
        $valor, 
        'DEPOSITO_MANUAL', 
        'ADM-' . time(), 
        "Depósito Manual Admin"
    );

    if ($resultado['success']) {
        sendResponse(true, "Sucesso! Saldo adicionado.", ['novo_saldo' => $resultado['novo_saldo']]);
    } else {
        throw new Exception($resultado['msg']);
    }

} catch (Exception $e) {
    sendResponse(false, $e->getMessage());
}
?>