<?php
// api/sistema_territorio.php
ini_set('display_errors', 0);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

if (file_exists('../conexao.php')) require '../conexao.php';
else require '../../conexao.php';

require 'Financeiro.php';

try {
    $acao = $_POST['acao'] ?? $_GET['acao'] ?? '';
    $email = $_POST['email'] ?? '';
    $nomeGoogle = $_POST['nome_google'] ?? '';
    
    $userId = null;
    $userDados = null;
    
    if ($email) {
        $stmt = $pdo->prepare("SELECT id, saldo, nome, clan_tag, cor_territorio FROM usersblock WHERE email = ?");
        $stmt->execute([$email]);
        $userDados = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($userDados) {
            $userId = $userDados['id'];
            // Atualiza nome se necessário
            if ($nomeGoogle && $userDados['nome'] !== $nomeGoogle) {
                $pdo->prepare("UPDATE usersblock SET nome = ? WHERE id = ?")->execute([$nomeGoogle, $userId]);
                $userDados['nome'] = $nomeGoogle;
            }
        }
    }

    // --- LEITURA DO MAPA ---
    if ($acao === 'ler_mapa') {
        $mapaId = 1;
        
        // CORRIGIDO: Trazemos email e id do dono para saber se "Sou Eu"
        $sql = "SELECT t.*, u.cor_territorio, u.clan_tag, u.email as email_dono 
                FROM territorios t 
                LEFT JOIN usersblock u ON t.dono_id = u.id 
                WHERE t.mapa_id = ?";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$mapaId]);
        $territorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Tratamento de cores e game_id_ativo
        foreach ($territorios as &$t) {
            $t['cor_visual'] = ($t['cor_territorio'] && strlen($t['cor_territorio']) > 3) ? $t['cor_territorio'] : '#555555';
            
            // Verifica se tem jogo ativo neste território
            $sqlGame = "SELECT game FROM games WHERE alvo_territorio_id = ? AND status = 'iniciado' LIMIT 1";
            $stmtGame = $pdo->prepare($sqlGame);
            $stmtGame->execute([$t['id']]);
            $t['game_id_ativo'] = $stmtGame->fetchColumn();
        }

        $stats = ['grupos' => 0, 'territorios' => 0];
        $meusLivres = [];

        if ($userId) {
            $stats['grupos'] = $pdo->query("SELECT COUNT(*) FROM grupos_ataque WHERE dono_id = $userId AND status = 'pronto'")->fetchColumn();
            $stmtT = $pdo->query("SELECT id, nome_personalizado FROM territorios WHERE dono_id = $userId AND em_guerra = 0");
            $meusLivres = $stmtT->fetchAll(PDO::FETCH_ASSOC);
            $stats['territorios'] = $pdo->query("SELECT COUNT(*) FROM territorios WHERE dono_id = $userId")->fetchColumn();
        }

        // Histórico
        $historico = [];
        if ($userId) {
            $sqlH = "SELECT * FROM games WHERE (p1 = ? OR p2 = ?) AND status IN ('finalizado','iniciado') ORDER BY played DESC LIMIT 10";
            $stmtH = $pdo->prepare($sqlH);
            $stmtH->execute([$userId, $userId]); // Aqui usamos o ID numérico, que é o certo
            $historico = $stmtH->fetchAll(PDO::FETCH_ASSOC);
        }

        echo json_encode([
            'success' => true,
            'territorios' => $territorios,
            'stats' => $stats,
            'meus_territorios_livres' => $meusLivres,
            'user_info' => $userDados,
            'historico' => $historico
        ]);
        exit;
    }

    if (!$userId) throw new Exception("Login necessário.");
    $banco = new Financeiro($pdo);

    // --- COMPRAR ---
    if ($acao === 'comprar_territorio') {
        $x = $_POST['x']; $y = $_POST['y']; $nome = $_POST['nome_territorio']; $cor = $_POST['cor'];
        if ($userDados['saldo'] < 2.00) throw new Exception("Saldo insuficiente.");
        
        $pdo->beginTransaction();
        $check = $pdo->query("SELECT id, dono_id FROM territorios WHERE mapa_id=1 AND posicao_x=$x AND posicao_y=$y FOR UPDATE")->fetch();
        if ($check && $check['dono_id']) { $pdo->rollBack(); throw new Exception("Ocupado."); }
        
        // Grava DONO_ID e NOME_DONO (para facilitar leitura)
        $sql = $check ? "UPDATE territorios SET dono_id=?, nome_dono=?, nome_personalizado=?, valor_atual=2.00 WHERE id=?" 
                      : "INSERT INTO territorios (mapa_id, posicao_x, posicao_y, dono_id, nome_dono, nome_personalizado) VALUES (1, ?, ?, ?, ?, ?)";
        $params = $check ? [$userId, $nomeGoogle, $nome, $check['id']] : [$x, $y, $userId, $nomeGoogle, $nome];
        $pdo->prepare($sql)->execute($params);
        
        $pdo->prepare("UPDATE usersblock SET cor_territorio=? WHERE id=?")->execute([$cor, $userId]);
        $banco->processarTransacao($userId, -2.00, 'COMPRA', "MAP-$x-$y");
        $pdo->commit(); echo json_encode(['success'=>true]); exit;
    }

    // --- ATACAR ---
    if ($acao === 'atacar') {
        $alvoId = $_POST['alvo_id']; $modo = $_POST['modo']; $origemId = $_POST['origem_id'] ?? null;
        $pdo->beginTransaction();
        
        $alvo = $pdo->query("SELECT * FROM territorios WHERE id=$alvoId FOR UPDATE")->fetch();
        if (!$alvo['dono_id'] || $alvo['dono_id'] == $userId || $alvo['em_guerra']) {
            $pdo->rollBack(); throw new Exception("Alvo inválido.");
        }
        
        $p2Name = $alvo['nome_dono'] ?: "Rival";
        $p2Id = $alvo['dono_id']; // ID Numérico do defensor

        // Consome Munição
        if ($modo == 'grupo') {
            $g = $pdo->query("SELECT id FROM grupos_ataque WHERE dono_id=$userId AND status='pronto' LIMIT 1 FOR UPDATE")->fetch();
            if(!$g) throw new Exception("Sem grupos.");
            $pdo->query("UPDATE grupos_ataque SET status='em_missao' WHERE id=".$g['id']);
        } else {
            $pdo->query("UPDATE territorios SET em_guerra=1 WHERE id=$origemId");
        }

        $gameId = rand(100000,999999);
        $sql = "INSERT INTO games (game, p1, p1Name, p2, p2Name, name, status, tipo_disputa, alvo_territorio_id, played, bet) 
                VALUES (?, ?, ?, ?, ?, ?, 'iniciado', ?, ?, NOW(), 0)";
        $pdo->prepare($sql)->execute([$gameId, $userId, $nomeGoogle, $p2Id, $p2Name, "Invasão: ".$alvo['nome_personalizado'], $modo, $alvoId]);
        
        $pdo->query("UPDATE territorios SET em_guerra=1 WHERE id=$alvoId");
        $pdo->commit();
        
        echo json_encode(['success'=>true, 'game_id'=>$gameId, 'p2_name'=>$p2Name, 'p2_id'=>$p2Id]); 
        exit;
    }
    
    // ... (Manter: comprar_grupo, abandonar, atualizar_perfil - igual ao anterior) ...
    // Estou omitindo para brevidade, mas devem estar aqui!
    if ($acao === 'atualizar_perfil') {
        $cor = $_POST['cor']; $clan = $_POST['clan'];
        $pdo->prepare("UPDATE usersblock SET cor_territorio=?, clan_tag=? WHERE id=?")->execute([$cor, strtoupper($clan), $userId]);
        echo json_encode(['success'=>true]); exit;
    }
    if ($acao === 'comprar_grupo') {
         if ($userDados['saldo'] < 2.00) throw new Exception("Saldo insuficiente.");
         $pdo->beginTransaction();
         $pdo->prepare("INSERT INTO grupos_ataque (dono_id, valor_investido) VALUES (?, 2.00)")->execute([$userId]);
         $banco->processarTransacao($userId, -2.00, 'TAXA_ATAQUE', "GRUPO");
         $pdo->commit(); echo json_encode(['success'=>true]); exit;
    }
    if ($acao === 'abandonar') {
        $id = $_POST['id'];
        $pdo->beginTransaction();
        $check = $pdo->query("SELECT em_guerra FROM territorios WHERE id=$id AND dono_id=$userId FOR UPDATE")->fetch();
        if(!$check || $check['em_guerra']) { $pdo->rollBack(); throw new Exception("Erro."); }
        $pdo->query("UPDATE territorios SET dono_id=NULL, nome_dono=NULL, em_guerra=0 WHERE id=$id");
        $banco->processarTransacao($userId, 2.00, 'DEPOSITO', "VENDA-$id");
        $pdo->commit(); echo json_encode(['success'=>true]); exit;
    }

} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['success' => false, 'msg' => $e->getMessage()]);
}
?>