<?php
// api/get_user_data.php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

// Conexão simplificada (ajuste o caminho se necessário)
if (file_exists('../conexao.php')) require '../conexao.php';
else require '../../conexao.php';

$email = $_GET['email'] ?? '';

if (!$email) {
    echo json_encode(['error' => 'Email não informado']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id, nome, saldo FROM usersblock WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo json_encode($user);
    } else {
        echo json_encode(['id' => 0, 'nome' => 'Desconhecido']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>